#include "config.h"
 

volatile	u8	gu8v_Beep_Mode;
volatile	u8	gbv_Beep_Count;
volatile	u8	gu8v_500msCount;

 
DEFINE_ISR(Timebase0,Timebase0_VECTOR)
{	
	gu8v_500msCount++;	
	gbv_Flag_500ms	=	1;	
}

DEFINE_ISR(Timebase1,Timebase1_VECTOR)
{	
	if(gbv_Flag_KEY_Halt_Enable )
	{
		if(KEY_PORT == 1)
		{		
			gbv_Flag_Key_Lock = 1;	
			gu8v_KeyCount=0x00;
		}
		else if(gbv_Flag_Key_Lock)
		{
			if(KEY_PORT == 0)
			{
				gu8v_KeyCount++;
				if(gu8v_KeyCount > 1)
				{
					gbv_Flag_Key_Lock=0;
					gu8v_KeyCount = 0;
					gu8v_SysMode  = Halt_Mode;
					gbv_Flag_Key_SET_HALT=1;
					DISABLE_Periph_ASAP();//按鍵按下，立即進入休眠	
				}		
			}
			else
			{
				gu8v_KeyCount = 0;
			}
		}
	}	
	//	Beep 
	switch(gu8v_Beep_Mode)
	{
		case 0:
			mac_BeepOff();
			gbv_Flag_Beep = 0;
			gbv_Beep_Count=0;
		break;
		case BEEP_1:
			if(gbv_Flag_Beep == 0)
			{
				gbv_Flag_Beep = 1;
				mac_BeepOn();	
			}
			else
			{
				mac_BeepOff();
				gu8v_Beep_Mode = 0;
			}
		break;
		case BEEP_1_1_1:
			gbv_Beep_Count++;
			if(gbv_Flag_Beep == 0)
			{
				gbv_Flag_Beep = 1;
				mac_BeepOn();	
			}
			else
			{
				mac_BeepOff();
				gbv_Flag_Beep = 0;
				if(gbv_Beep_Count>4)
				{
					gbv_Beep_Count = 0;
					gu8v_Beep_Mode = 0;	
				}
					
			}
		break;
		default:
			gu8v_Beep_Mode=0;
		break;
		
	}	
}
